#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <stdlib.h>



//  
#define F_CPU 16000000UL 		        //    (16 MHz)
#define INCDIRECTION		YDIR	    //   XDIR (), YDIR ()
#include "proc.h"						//  
#include "adjectives.h"					//  
#include "keyboard.h"					// 
#include "lcd.h"						//  +   (, , )
#include "draw_spr.h"					//  
#include "chr.h"						//  
#include "sdcard.h"						//   SD 
#include "window.h"						// 






void draw_score(unsigned char score)
{
 	

  char text[] = "0000000  ";

  for(unsigned char i=6; i>0; i--)
  {
    text[i] = 0x30 + score % 10;
    score/=10;
  }
  rectangle8(16+8+8+8+8,90,16+8+8+8+8+8,130+30,clBlue);
  put_string8(16+8+8+8+8,90,text,clWhite,clBlue);

}

void main()
{
keyboard_init(); 
lcd_init(0xFF);
sdcard_init();

window(0,0,cSCHeight,cSCWidth,clBlue,PSTR(" "),clWhite);

pgm_put_string8(16,4,PSTR("  "),clWhite,clBlue);
pgm_put_string8(16+8,4,PSTR("  "),clWhite,clBlue);
pgm_put_string8(16+8+8,4,PSTR("    1+2"),clWhite,clBlue);
pgm_put_string8(16+8+8+8+8,30,PSTR(" :"),clWhite,clBlue);

while (1) 
{
	wait_key_pressed();
	if (PINC==63) {boot_start();}
	draw_score(PINC);
}


}
